
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              Oktober 2018                         *
*****************************************************

*****************************************************
*     Aufbereitung der Daten für den Kurs 
*****************************************************

/* Damit kann man den Output der Regressionstabellen
* auf weniger Nachkommastellen begrenzen
* Achtung: Sitzungsüberdauernd!
set cformat %9.4f, permanently        //Format der Koeff, S.E, KI 
set pformat %5.3f, permanently        //Format des p-value
set showbaselevels on, permanently    //Anzeigen der Referenzkategorie
*/


clear 
set more off
version 15

* Daten: ALLBUS 2002
cd   "C:\Users\bruederl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\Allbus 2002\"    //Datenverzeichnis
use  Allbus02, clear


*-----------------------------------------------
* Die abhängigen Variablen
*-----------------------------------------------

* Monatsnettoeinkommen
generate   eink = v361

* Links-Rechts Selbsteinstufung (Skala von 1-10)
generate   rechts = v106

* Arbeitslosigkeit in den letzten 10 Jahren
gen     arblos = v217            //Erwerbstätige, in den letzten 10 Jahren arblos
recode  arblos 2 = 0
recode  arblos . = 1 if v220==3  //plus gegenwärtig Arbeitslose

* Wahlabsicht (Sonntagsfrage)
generate partei = v521
recode   partei 1=1 2=2 3=3 4=4 6=5  5 7 8=.
label define partlbl 1 "CDU" 2 "SPD" 3 "FDP" 4 "Grüne" 5 "PDS"
label value partei partlbl

tab1 rechts partei arblos, m
summ eink, d

* Nettoäquivalenzeinkommen
generate   hheink = v441                 //monatliches Netto-HHeinkommen
tab v363                     			 //HHgröße
generate   hhvorst = 1       			 //jeder HH hat einen Haushaltsvorstand
replace    hhvorst = . if v363==.
generate   sonst   = 0       			 //Initialisierung "Zahl sonstiger Personen über 14"
generate   kind14  = 0       			 //Initialisierung "Zahl Kinder unter 15"
replace    kind14  = kind14+1 if v369<15   //Bestimmung der Zahl der Kinder unter 15
replace    kind14  = kind14+1 if v379<15
replace    kind14  = kind14+1 if v389<15
replace    kind14  = kind14+1 if v399<15
replace    kind14  = kind14+1 if v409<15
replace    kind14  = kind14+1 if v419<15
replace    kind14  = kind14+1 if v429<15
replace    kind14  = . if v363==.
replace    sonst   = v363 - kind14 - 1	  //Bestimmung der sonstigen Personen als Residualgröße
* Berechnung des bedarfsgewichteten Pro-Kopf-Einkommens 
* (Äquivalenzeinkommen) nach der OECD-Skala. Die OECD-Gewichte sind
* Haushaltsvorstand:         1.0
* weitere Personen über 14:  0.7
* Kinder unter 15:           0.5 
generate   oecdeink = hheink / (1*hhvorst + 0.7*sonst + 0.5*kind14)
gen        oecdeink1 = oecdeink        //Ausreisser wird auf 6000 rekodiert
recode     oecdeink1 6000/max=6000


*-----------------------------------------------
* Die unabhängigen Variablen
*-----------------------------------------------

* Bildung in Jahren
recode   v187 1=8 2=9 3=10 4=12 5=13 6=10 7=.
generate bild=v187
replace  bild=bild+0.5 if (v188==1) 
replace  bild=bild+1   if (v189==1) 
replace  bild=bild+1.5 if (v190==1) 
replace  bild=bild+1.5 if (v191==1) 
replace  bild=bild+0.5 if (v192==1) 
replace  bild=bild+1.5 if (v193==1) 
replace  bild=bild+2   if (v194==1) 
replace  bild=bild+3   if (v195==1) 
replace  bild=bild+4   if (v196==1) 
replace  bild=bild+5   if (v197==1) 
replace  bild=bild+0.5 if (v198==1) 

* Magnitudeprestige Vater
generate   prestv = v312

* Alter
generate   alter = v185

* Berufserfahrung
generate   exp = alter - bild - 6
recode     exp   -1=0

* Region
generate   ost = v3 - 1

* Geschlecht
generate   frau = v182 - 1

* Berufliche Stellung
recode   v201 1/3=4  4=3  5=2  6=1  7/9=.
generate beruf = v201
label define  lblber 1 "Arbeiter" 2 "Angestellter" 3 "Beamter" 4 "Selbständiger"
label value   beruf lblber

summ bild prestv exp alter, d
tab1 ost frau beruf, m

*-----------------------------------------------
* Variable zur Fallselektion
*-----------------------------------------------

* Hauptberuflich ganztags erwerbstätig
generate  hauptber = v200==1
replace   hauptber = . if v200==.
tab hauptber, m


*-----------------------------------------------
* Speichern des Datensatzes
*-----------------------------------------------
keep   eink - hauptber       // wir behalten nur die neu gebildeten Variablen

misstable summarize, all     // Übersicht über die Missing

compress                     // spart Platz

cd "C:\Users\bruederl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
save AllbReg, replace
